
rem
Houses collision pairs as geom1 and geom2. The pairs are always ordered such
that the lower id geometry is first. This allows the CollisionPairDictionary
to have a consistent key / hash code for a pair of geometry.
end rem
Type TCollisionPair
	
	Field geom1:TGeom
	Field geom2:TGeom
	
	Function Create:TCollisionPair(g1:TGeom, g2:TGeom)
		Assert g1 <> g2, "Cannot be same geoms in collision pair"
		Local cp:TCollisionPair = New TCollisionPair
		
		If TGeom.LessThan(g1, g2) Then
			cp.geom1 = g1
			cp.geom2 = g2
		Else
			cp.geom1 = g2
			cp.geom2 = g1
		End If
		Return cp
	End Function
	
	Method GetHashCode:Int()
		' arbitrarily choose 10000 as a number of colliders 
		' that we won't approach any time soon
		Return geom1._id * 10000 + geom2._id
	End Method
	
	' used for tmap comparisions
	Method Compare:Int(o:Object)
		Local other:TCollisionPair = TCollisionPair(o)
		Return GethashCode() - other.GetHashCode()
	End Method
End Type
